/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.util;

import com.github.monun.survival.tap.util.GitHubSupport;
import com.github.monun.survival.tap.util.GitHubSupportKt;
import com.github.monun.survival.tap.util.UpToDateException;
import com.github.monun.survival.tap.util.VersionSupportKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042!\b\u0002\u0010\u0012\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0014\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0015\u00f8\u0001\u0000J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lcom/github/monun/survival/tap/util/GitHubSupport;", "", "()V", "GITHUB_API", "", "KEY_ASSETS", "KEY_BROWSER_DOWNLOAD_URL", "KEY_NAME", "KEY_TAG_NAME", "REQUEST_ACCEPT", "downloadLatestRelease", "", "file", "Ljava/io/File;", "owner", "project", "version", "asset", "callback", "Lkotlin/Function1;", "Lkotlin/Result;", "Lkotlin/ExtensionFunctionType;", "generateUrlGitHubLatestRelease", "api"})
public final class GitHubSupport {
    private static final String GITHUB_API = "https://api.github.com";
    private static final String KEY_ASSETS = "assets";
    private static final String KEY_NAME = "name";
    private static final String KEY_TAG_NAME = "tag_name";
    private static final String KEY_BROWSER_DOWNLOAD_URL = "browser_download_url";
    private static final String REQUEST_ACCEPT = "application/vnd.github.v3+json";
    @NotNull
    public static final GitHubSupport INSTANCE;

    @NotNull
    public final String generateUrlGitHubLatestRelease(@NotNull String owner, @NotNull String project) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return "https://api.github.com/repos/" + owner + '/' + project + "/releases/latest";
    }

    public final void downloadLatestRelease(@NotNull File file, @NotNull String owner, @NotNull String project, @NotNull String version, @NotNull String asset, @Nullable Function1<? super Result<String>, Unit> callback) {
        block10: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
            boolean bl = false;
            try {
                Object v5;
                block9: {
                    object2 = Result.Companion;
                    boolean bl2 = false;
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                    }
                    URL latestReleaseURL = new URL(INSTANCE.generateUrlGitHubLatestRelease(owner, project));
                    JsonObject releaseInfo2 = (JsonObject)GitHubSupportKt.httpRequest(latestReleaseURL, downloadLatestRelease.1.releaseInfo.1.INSTANCE);
                    JsonElement jsonElement = releaseInfo2.get(KEY_TAG_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"releaseInfo[KEY_TAG_NAME]");
                    object = jsonElement.getAsString();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Object it = object;
                    boolean bl5 = false;
                    Object object3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
                    if (VersionSupportKt.compareVersion(version, (String)object3) >= 0) {
                        throw (Throwable)new UpToDateException("UP TO DATE");
                    }
                    JsonArray jsonArray = releaseInfo2.getAsJsonArray(KEY_ASSETS);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"releaseInfo.getAsJsonArray(KEY_ASSETS)");
                    Iterable iterable = CollectionsKt.filterIsInstance((Iterable)((Iterable)jsonArray), JsonObject.class);
                    bl4 = false;
                    it = iterable;
                    boolean bl6 = false;
                    Iterator iterator = it.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        JsonObject it2 = (JsonObject)t;
                        boolean bl7 = false;
                        JsonElement jsonElement2 = it2.get(KEY_NAME);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"it[KEY_NAME]");
                        if (!Intrinsics.areEqual((Object)jsonElement2.getAsString(), (Object)asset)) continue;
                        v5 = t;
                        break block9;
                    }
                    v5 = null;
                }
                JsonObject jsonObject = v5;
                if (jsonObject == null) {
                    throw (Throwable)new IllegalArgumentException("Not found asset for " + asset);
                }
                JsonObject foundAsset = jsonObject;
                JsonElement jsonElement = foundAsset.get(KEY_BROWSER_DOWNLOAD_URL);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"foundAsset[KEY_BROWSER_DOWNLOAD_URL]");
                URL downloadURL = new URL(jsonElement.getAsString());
                GitHubSupportKt.downloadTo(downloadURL, file);
                String string2 = downloadURL.getPath();
                boolean latestReleaseURL = false;
                object2 = Result.constructor-impl((Object)string2);
            }
            catch (Throwable throwable) {
                Result.Companion latestReleaseURL = Result.Companion;
                boolean releaseInfo2 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object4 = object2;
            boolean bl8 = false;
            boolean bl9 = false;
            if (Result.isSuccess-impl((Object)object4)) {
                String it = (String)object4;
                boolean bl10 = false;
                Function1<? super Result<String>, Unit> function1 = callback;
                if (function1 != null) {
                    object = Result.Companion;
                    boolean bl11 = false;
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)it)));
                }
            }
            bl8 = false;
            bl9 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
            if (throwable == null) break block10;
            Throwable throwable2 = throwable;
            boolean bl12 = false;
            boolean bl13 = false;
            object = throwable2;
            boolean bl14 = false;
            Object it = object;
            boolean bl15 = false;
            Function1<? super Result<String>, Unit> function1 = callback;
            if (function1 != null) {
                Result.Companion companion = Result.Companion;
                boolean bl16 = false;
                Unit cfr_ignored_1 = (Unit)function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
            }
        }
    }

    public static /* synthetic */ void downloadLatestRelease$default(GitHubSupport gitHubSupport, File file, String string2, String string3, String string4, String string5, Function1 function1, int n, Object object) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        gitHubSupport.downloadLatestRelease(file, string2, string3, string4, string5, (Function1<? super Result<String>, Unit>)function1);
    }

    private GitHubSupport() {
    }

    static {
        GitHubSupport gitHubSupport;
        INSTANCE = gitHubSupport = new GitHubSupport();
    }
}

